/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**   
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**      
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/  

/**
 * \file    ioexpander.c
 *
 * \brief   Utility Routine for testing the GPIO Expander
 *
 * This file contains the utility routines for testing the GPIO Expander
 * on the DM814X EVM.
 *
 * \author  0043
 *
 * \version 01a,25aug,2010 Created
 */

/*
 *====================
 * Includes
 *====================
 */
#include "DM814x_types.h"
#include "DM814x_EVM.h"
#include "DM814x_i2c.h"

#include "ioexpander.h"

#include "stdio.h"
 
 /*
 *====================
 * Defines
 *====================
 */
		
/*
 *====================
 * Function implementations
 *====================
 */
 /** **************************************************************************
 * \n \brief Routine to get the states of switches
 *
 * This routine gets the states of switches.It takes states of the Switches 
 * as a parameter.
 *
 * \param *pu8Val		[IN]	buffer pointer which has the states of the 
 *                              switches.
 *                              
 *
 * \return
 * \n      return SUCCESS for success  - Description 
 * 
 */

STATUS sw_get( UINT8* pu8Val )  
{
	STATUS u32RetVal = SUCCESS;
	
    UINT8 outData;
    UINT8 val[2];
    val[0] = 0x00;                       /* Lower 8 IOs */
    val[1] = 0x00;                       /* Higher 8 IOs */
	u32RetVal = DM814xI2cRead (GPIO_EXP_I2C_BUS_NUM, GPIO_EXP_SLAVE_ADDR, val, 2, &outData);
	* pu8Val =  (val[0] & 0x0F);
    return (u32RetVal);           /* Lower four bits of the lower 8 bits are SWs */
}        
/** **************************************************************************
 * \n \brief Routine to set the state of single user LED
 *
 * This routine sets single LED.It takes num as paramter which gives Led number
 * along with that state that LED to be made.
 * 
 *
 * \param num		[IN]	LED number
 * \param state     [IN]    State LED to be made (1 or 0)
 * 
 * \return
 * \n      return SUCCESS on successful completion of the routine
 * 
 */

STATUS led_set_num(UINT8 num, UINT8 state )
{
	STATUS u32RetVal = SUCCESS;
    UINT8 outData;
    UINT8 val[2];
    
	u32RetVal = DM814xI2cRead (GPIO_EXP_I2C_BUS_NUM, GPIO_EXP_SLAVE_ADDR, val, 2, &outData);    /* Get the current state so it isnt overwritten*/
    val[0] = val[0] & (1 << (num + 4));              /* Upper four bits of the lower 8 bits are LEDs */
    val[0] = val[0] | (state << (num + 4)); 
	u32RetVal = DM814xI2cWite (GPIO_EXP_I2C_BUS_NUM, GPIO_EXP_SLAVE_ADDR, val, 2, &outData);
	return (u32RetVal);
}
/** **************************************************************************
 * \n \brief Routine to set all user LEDs
 *
 * This routine sets the state of all LEDs.It takes pat as paramter which gives 
 * the state of all LEDs.Returns 0 on successfull completion of the routine
 * 
 *
 * \param pat		[IN]	State of all LEDs to be made
 * 
 * 
 * \return
 * \n      return SUCCESS on successful completion of the routine
 * 
 */

STATUS led_set_pat(UINT8 pat )
{
	STATUS u32RetVal = SUCCESS;
    UINT8 outData;
	UINT8 val[2];
    u32RetVal = DM814xI2cRead(GPIO_EXP_I2C_BUS_NUM, GPIO_EXP_SLAVE_ADDR, val, 2, &outData);   /* Get the current state so it isnt overwritten */
    val[0] = val[0] & 0x0F;                         /* Upper four bits of the lower 8 bits are LEDs */
    val[0] = val[0] | (pat <<  4); 
	u32RetVal = DM814xI2cWite (GPIO_EXP_I2C_BUS_NUM, GPIO_EXP_SLAVE_ADDR, val, 2, &outData);
    return (u32RetVal);
}


